package org.eclipse.jem.tests.beaninfo;
/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.beans.*;

import org.eclipse.jem.tests.beaninfo.preq.infos.BaseBeanInfo;
/** 
 * This is a do nothing beaninfo so that Introspection
 * on the remote vm occurs but reflection will be performed.
 * This will test that the remote vm is recycled as needed.
 */

public class TestChangesClassBeanInfo extends BaseBeanInfo {
	
/**
 * Gets the bean class.
 * @return java.lang.Class
 */
public Class getBeanClass() {
	return TestChangesClass.class;
}
public BeanDescriptor getBeanDescriptor() {
	java.beans.BeanDescriptor aDescriptor = null;
	try {
		/* Create and return the WindowBeanInfobean descriptor. */
		aDescriptor = new java.beans.BeanDescriptor(getBeanClass());
	} catch (Throwable exception) {
	};
	return aDescriptor;
}

/**
 * @return an icon of the specified kind for JButton
 */
public java.awt.Image getIcon(int kind) {
	return super.getIcon(kind);
}

}